﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Business.Db" %>
<%@ import Namespace="Soneta.Business.App" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Pełny raport kasowy</title>
		<script runat="server">

            //Sortowyanie chronologiczne (standardowo wydruk jest sortowany zgodne z numerami dokumentów)
            static bool wydrukChronologiczny = true;

            class Element : IComparable {
                readonly string nazwa;
                readonly Operator oper;
                decimal wpłaty;
                decimal wypłaty;
                public Element(Zaplata z) {
                    this.nazwa = z.SposobZaplaty.Nazwa;
                    this.oper = mapa[z];
                }
                public void Add(Zaplata z) {
                    if (oper != mapa[z])
                        throw new BusException("Wybrano zły obiekt podsumowania.");
                    wpłaty += z.Wpłata.Value;
                    wypłaty += z.Wypłata.Value;
                }
                public int CompareTo(object v) {
                    Element ev = (Element)v;
                    int result = string.Compare(Nazwa, ((Element)v).Nazwa, true);
                    if (result != 0)
                        return result;
                    if (oper == ev.oper)
                        return 0;
                    if (oper == null)
                        return -1;
                    if (ev.oper == null)
                        return 1;
                    return oper.ToString().CompareTo(ev.ToString());
                }
                public string Nazwa {
                    get { return nazwa; }
                }
                public Operator Operator {
                    get { return oper; }
                }
                public decimal Wpłata {
                    get { return wpłaty; }
                }
                public decimal Wypłata {
                    get { return wypłaty; }
                }
                public decimal Saldo {
                    get { return wpłaty - wypłaty; }
                }
            }
    
       class Element2 {
           readonly string nazwa;
           object wpłaty;
           object wypłaty;
           static string marker = "--------------";
           public Element2(string nazwa, object wpłaty, object wypłaty) {
               this.nazwa = nazwa;
               this.wpłaty = wpłaty;
               this.wypłaty = wypłaty;
           }
           public string Nazwa {
               get { return nazwa; }
           }
           public object Wpłata {
               get { return wpłaty!=null ? wpłaty : marker; }
           }
           public object Wypłata {
               get { return wypłaty!=null ? wypłaty : marker; }
           }
       }
    
       Hashtable elements = new Hashtable();
       decimal sumWpł = 0;
       decimal sumWypł = 0;
    
    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
           Zaplata z = (Zaplata)args.Row;
           if (z.NumeryDokumentow==""||z.Opis.Contains(z.NumeryDokumentow))
               opis.EditValue = z.Opis;
           else
               opis.EditValue = z.Opis + ", " + z.NumeryDokumentow;
    
        Operator oper = mapa[z];
        string key = z.SposobZaplaty + "|" + (oper == null ? "" : oper.ToString());
        Element elem = (Element)elements[key];
           if (elem==null)
               elements.Add(key, elem = new Element(z));
           elem.Add(z);
    
           sumWpł += z.Wpłata.Value;
           sumWypł += z.Wypłata.Value;
        
        Operator op = mapa[z];
        Grid1.GroupLine = "Zatwierdził: " + (op == null ? "" : op.ToString());
    }
    
    void Grid1_AfterRender(Object sender, EventArgs args) {
        RaportESP raport = (RaportESP)dc[typeof(RaportESP)];
           ArrayList arr = new ArrayList(elements.Values);
           arr.Sort();
           Grid2.DataSource = arr;
    
           Element2[] els = new Element2[3];
           els[0] = new Element2("Obroty", sumWpł, sumWypł);
           els[1] = new Element2("Stan poprzedni", GT(raport.SaldoPoczatkowe.Value), LT(raport.SaldoPoczatkowe.Value));
           els[2] = new Element2("Stan obecny", LT(raport.SaldoKoncowe.Value), GT(raport.SaldoKoncowe.Value));
    
           Grid3.DataSource = els;
       }
    
       object GT(decimal value) {
           if (value>0)
               return value;
           return null;
       }
    
       object LT(decimal value) {
           if (value<0)
               return -value;
           return null;
       }

            BusinessModule business;
            static System.Collections.Generic.Dictionary<Zaplata, Operator> mapa = null;

            protected void dc_ContextLoad(object sender, EventArgs e) 
			{
	            mapa = new System.Collections.Generic.Dictionary<Zaplata, Operator>();


                RaportESP raport = (RaportESP)dc[typeof(RaportESP)];
                business = BusinessModule.GetInstance(dc);
                if (raport.Kasa.Typ != TypEwidencjiSP.Kasa) {
                    opis.Width += numer.Width;
                    numer.Visible = false;
                    ReportHeader1.Title = "Wyciąg bankowy|</strong>Ewidencja:<strong> {0}</strong>, waluta:<strong> {1}|</strong>Numer:<strong> {2}|</strong>Okres:<strong> {3}";
                }

                System.Collections.Generic.List<Zaplata> zapłaty = new System.Collections.Generic.List<Zaplata>();
                foreach (Zaplata z in raport.Zaplaty) {
                    mapa.Add(z, GetZatwierdził(z));
                    zapłaty.Add(z);
                }

                zapłaty.Sort(new CompareZaplata());

                Grid1.DataSource = zapłaty;

                if (wydrukChronologiczny)
                    lp.DataMember = "#";
            }

            class CompareZaplata : System.Collections.Generic.IComparer<Zaplata> {
                public int Compare(Zaplata x, Zaplata y) {
                    Operator ox = mapa[x];
                    Operator oy = mapa[y];

                    int result;
                    if (ox == null)
                        result = oy == null ? 0 : 1;
                    else if (oy == null)
                        result = - 1;
                    else
                        result = ox.ToString().CompareTo(oy.ToString());

                    if (result == 0)
                        if (wydrukChronologiczny) {
                            result = x.DataDokumentu.CompareTo(y.DataDokumentu);
                            if (result == 0)
                                result = x.NumerDokumentu.CompareTo(y.NumerDokumentu);
                        }
                        else
                            result = x.Lp.CompareTo(y.Lp);
                    return result;
                }
            }
		        
            Operator GetZatwierdził(Zaplata zapłata) {
                IDokumentKasowy dokument = zapłata.Dokument;
                GuidedRow row = dokument as GuidedRow;
                if (row != null)
                foreach (ChangeInfo info in business.ChangeInfos[row])
                    if (info.Type == ChangeInfoType.Accepted)
                        return info.Operator;
                return null;
            }
		    
</script>

	</HEAD>
	<body>
		<form id="PełnyRaportKasowy" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Kasa.RaportESP, Soneta.Kasa" OnContextLoad="dc_ContextLoad"></ea:datacontext>
			<cc1:ReportHeader id="ReportHeader1" title="Raport kasowy|</strong>Ewidencja:<strong> {0}</strong>, waluta:<strong> {1}|</strong>Numer:<strong> {2}|</strong>Okres:<strong> {3}"
				runat="server" DataMember3="Okres" DataMember2="Numer" DataMember1="Kasa.Waluta.Symbol" DataMember0="Kasa"></cc1:ReportHeader>
			<ea:sectionmarker id="SectionMarker2" runat="server"></ea:sectionmarker>
			<ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Kasa.Zaplata, Soneta.Kasa, Version=1.0.1118.12462, Culture=neutral, PublicKeyToken=null"
				OnAfterRender="Grid1_AfterRender" ShowGroupSum="True">
				<Columns>
					<ea:GridColumn EncodeHTML="true" Width="4" Align="Right" DataMember="Lp" Caption="LP." ID="lp" runat="server"></ea:GridColumn>
					<ea:GridColumn EncodeHTML="true" Width="10" DataMember="DataDokumentu" Caption="Data" ID="data" runat="server"></ea:GridColumn>
					<ea:GridColumn EncodeHTML="true" Width="20" DataMember="NumerDokumentu" Caption="Numer" ID="numer" NoWrap="True" runat="server"></ea:GridColumn>
					<ea:GridColumn EncodeHTML="true" Width="12" DataMember="Podmiot.Kod" Caption="Podmiot" ID="podmiot" NoWrap="True" runat="server"></ea:GridColumn>
					<ea:GridColumn EncodeHTML="true" Width="32" Caption="Opis" ID="opis" NoWrap="True" runat="server"></ea:GridColumn>
					<ea:GridColumn EncodeHTML="true" DataMember="SposobZaplaty" Caption="Spos&#243;b zapłaty" runat="server" Total="Info"></ea:GridColumn>
					<ea:GridColumn EncodeHTML="true" Width="12" Align="Right" DataMember="Wpłata" Total="Sum" Caption="Wpłata" HideZero="True"
						Format="{0:n}" ID="Wpłata" runat="server"></ea:GridColumn>
					<ea:GridColumn EncodeHTML="true" Width="12" Align="Right" DataMember="Wypłata" Total="Sum" Caption="Wypłata" HideZero="True"
						Format="{0:n}" ID="wypłata" runat="server"></ea:GridColumn>
				</Columns>
			</ea:grid>
			<ea:sectionmarker id="Sectionmarker1" runat="server"></ea:sectionmarker>
            <ea:Section>
			    <table id="Table3" cellspacing="5" width="100%">
				    <tbody>
					    <tr>
						    <td valign="top">
							    <ea:grid id="Grid2" runat="server" GroupData0="Nazwa" GroupLine="Sposób zapłaty: {0}" ShowGroupSum="True" WithSections="false">
								    <Columns>
									    <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." ID="lp2" runat="server"></ea:GridColumn>
									    <ea:GridColumn DataMember="Operator" Total="Info" Caption="Operator" runat="server"></ea:GridColumn>
									    <ea:GridColumn Width="14" Align="Right" DataMember="Wpłata" Total="Sum" Caption="Wpłata" Format="{0:n}"
										    ID="wpłata2" HideZero="True" runat="server"></ea:GridColumn>
									    <ea:GridColumn Width="14" Align="Right" DataMember="Wypłata" Total="Sum" Caption="Wypłata" Format="{0:n}"
										    ID="wypłata2" HideZero="True" runat="server"></ea:GridColumn>
									    <ea:GridColumn Width="14" Align="Right" DataMember="Saldo" Total="Sum" Caption="R&#243;żnica" Format="{0:n}"
										    ID="saldo2" HideZero="True" runat="server"></ea:GridColumn>
								    </Columns>
							    </ea:grid>
						    </td>
						    <td valign="top" align="right">
							    <ea:grid id="Grid3" runat="server" WithSections="false">
								    <Columns>
									    <ea:GridColumn Width="14" DataMember="Nazwa" Total="Info" ID="pozycja3"></ea:GridColumn>
									    <ea:GridColumn Width="14" Align="Right" DataMember="Wpłata" Total="Sum" Caption="Wpłata" Format="{0:n}"
										    ID="wpłata3"></ea:GridColumn>
									    <ea:GridColumn Width="14" Align="Right" DataMember="Wypłata" Total="Sum" Caption="Wypłata" Format="{0:n}"
										    ID="wypłata3"></ea:GridColumn>
								    </Columns>
							    </ea:grid>
						    </td>
					    </tr>
				    </tbody>
			    </table>
            </ea:Section>
			<ea:SectionMarker id="SectionMarker3" runat="server" SectionType="Footer"></ea:SectionMarker>
			<cc1:ReportFooter id="ReportFooter1" runat="server">
				<Subtitles>
					<cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sporządził" SubtitleType="Podpis"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sprawdził" SubtitleType="Podpis"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Zatwierdził" SubtitleType="Data"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:ReportFooter>
		</form>
	</body>
</HTML>
